<?php
//============================================================+
// File name   : example_001.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 001 for TCPDF class
//               Default Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Default Header and Footer
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Sistema Pharmaster');
$pdf->SetTitle('Reporte de Ventas');
$pdf->SetSubject('Pharmaster');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
$pdf->setFooterData(array(0,64,0), array(0,64,128));

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/spa.php')) {
	require_once(dirname(__FILE__).'/lang/spa.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set default font subsetting mode
$pdf->setFontSubsetting(true);

// Set font
// dejavusans is a UTF-8 Unicode font, if you only need to
// print standard ASCII chars, you can use core fonts like
// helvetica or times to reduce file size.
$pdf->SetFont('dejavusans', '', 6, '', true);

// Add a page
// This method has several options, check the source code documentation for more information.
$pdf->AddPage('L');

// set text shadow effect
$pdf->setTextShadow(array('enabled'=>true, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

// Set some content to print
$html = <<<EOD
<h1>Nombre Producto</h1>
<p>SB0987745464</p>
<table>
							<thead>
								<tr>
									<th>#</th>
									<th>Farmacia</th>
									<th style="color:#2a23ba;">Uni.</th>
									<th style="color:#2a23ba;">Fra.</th>
									<th>Ene</th>
									<th>Feb</th>
									<th>Mar</th>
									<th>Abr</th>
									<th>May</th>
									<th>Jun</th>
									<th>Jul</th>
									<th>Ago</th>
									<th>Sep</th>
									<th>Oct</th>
									<th>Nov</th>
									<th>Dic</th>
									<th style="color:#a823ba;">Total <br>
										<span style="color:red;">Prom.</span>
									</th>
									
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>1</td>
									<td>
										<strong>Farmacia la Nueva #2</strong> <br>
										<span style="color:#0000FF;">401573</span><br>						
										<span style="color:gray">C. 12</span>
									</td>
									<td style="color:#2a23ba;">40</td>
									<td style="color:#2a23ba;">12.26</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td style="color:#a823ba;">
									12<br>
									<span style="color:red;">12</span>
									</td>
								</tr>
								<tr>
									<td>1</td>
									<td>
										<strong>Farmacia la Nueva #2</strong> <br>
										<span style="color:#0000FF;">401573</span><br>						
										<span style="color:gray">C. 12</span>
									</td>
									<td style="color:#2a23ba;">40</td>
									<td style="color:#2a23ba;">12.26</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td>12</td>
									<td style="color:#a823ba;">
									12<br>
									<span style="color:red;">12</span>
									</td>
								</tr>
								
								</tbody>
</table>
EOD;

// Print text using writeHTMLCell()
$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

// ---------------------------------------------------------

// Close and output PDF document
// This method has several options, check the source code documentation for more information.
$pdf->Output('reporteVentas_001.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+

