<?php

/* Classes ancestrais */
nm_load_class('page', 'Page');

/* Definicao da classe */
class nmPageProdLogin extends nmPage{

    function __construct() {
        $this->nm_sc_dev();
        $this->iniSession();
        $this->doAjax();
        $this->SetBody('nmPage');
        $this->SetMargin(10);
        $this->SetPage('ProdLogin');
        $this->SetPageSubtitle('');
    }

    function doAjax() {
        if (empty($_POST)) {
            header('Location: ../../nm_ini_manager2.php');
            exit;
        }

        if (isset($_POST['ajax']) && $_POST['ajax'] === 'nm') {
            $action = $_POST['nm_action'] ?? '';
            switch ($action) {
                case 'login':
                    $response = $this->checkFirstAccess();
                    break;
                case 'change_language':
                    $response = $this->changeLanguage($_POST['lang'] ?? '');
                    break;
                case 'change_pass':
                    $response = $this->changePass(
                        $_POST['pass_new'] ?? '',
                        $_POST['pass_conf'] ?? '',
                        $_POST['lang'] ?? '',
                        $_POST['email'] ?? '',
                        $_POST['captcha'] ?? '',
                        $_POST['nm_url_rand'] ?? ''
                    );
                    break;
                default:
                    $response = $this->checkFirstAccess();
            }
            echo $response;
            exit;
        }
    }

    function iniSession() {
        if (!isset($_SESSION['nm_session']['prod_v8'])) {
            $_SESSION['nm_session']['prod_v8'] = [
                'logged'    => false,
                'login'     => ['is_page' => true],
                'url_rand'  => [],
            ];
        }

        if (isset($_GET['login'], $_SESSION['nm_session']['cache']['prod_v8'])) {
            unset($_SESSION['nm_session']['cache']['prod_v8']);
            unset($_SESSION['nm_session']['prod_v8']['logged']);
        }

        $_SESSION['nm_session']['prod_v8']['login']['version']  = $this->nm_prod_get_version();
        $_SESSION['nm_session']['prod_v8']['login']['toggle']   = $this->nm_exclude_browser();
        $_SESSION['nm_session']['prod_v8']['login']['lang']     = $this->nm_prod_list_lang();
        $_SESSION['nm_session']['prod_v8']['login']['default']  = $this->getDefaultLang();

        if (!is_file($this->getDirConf().'prod.config.php') &&
            !is_file($this->getDirConf().'prod.pub.dir.php') &&
            is_dir("../../../_app_data")
        ) {
            $dir = str_replace('\\', '/', dirname(dirname(dirname(dirname(dirname(getcwd()))))));
            $str_file  = "<?php\r\n\$sc_arr_system_dir = array();\r\n";
            $str_file .= "\$sc_arr_system_dir[] = array('0' => '$dir');\r\n";
            file_put_contents($this->getDirConf().'prod.pub.dir.php', $str_file);
        }
    }

    function nm_unserialize($ini_file) {
        if (!is_file($ini_file)) {
            include_once($this->getDirProd().'/lib/php/nm_serialize.php');
            return nm_unserialize_ini($ini_file);
        }
        $content = file_get_contents($ini_file);
        if (substr($content, 0, 8) === '<?php /*') {
            $content = substr($content, 8, -5);
        }
        $arr = unserialize($content);
        return $arr ? $arr : [];
    }

    function checkFirstAccess() {
        $arr_ini = $this->nm_unserialize($this->getDirConf().'prod.config.php');
        $hasPassword = is_file($this->getDirConf().'prod.config.php') &&
                       isset($arr_ini['GLOBAL']['PASSWORD']) && 
                       !empty($arr_ini['GLOBAL']['PASSWORD']);
        return json_encode(['result' => $hasPassword ? 'login' : 'new_pass']);
    }

    function changePass($pass_new='', $pass_conf='', $lang='', $email='', $captcha='', $nm_url_rand='') {
        $hasPassword    = json_decode($this->checkFirstAccess(), true)['result'] === 'login';
        $isLogged       = $_SESSION['nm_session']['prod_v8']['logged'] ?? false;
        $isLoginPage    = $_SESSION['nm_session']['prod_v8']['login']['is_page'] ?? false;
        $isChangePass   = $_SESSION['nm_session']['prod_v8']['request_change_pass'] ?? false;
        $str_error      = '';
        if ($hasPassword && !$isLogged) {
            return json_encode(['result' => 'error', 'message' => 'Unauthorized']);
        }
        if (!$this->validate_nm_url_rand($nm_url_rand)) {
            return json_encode(['result' => 'error', 'message' => 'Unauthorized']);
        }
        if (!$isLoginPage && $isChangePass && $hasPassword) {
            return json_encode(['result' => 'error', 'message' => 'Unauthorized']);
        }
        include_once($this->getDirProd().'/lib/php/nm_ini_lib.php');
        $lang = str_replace('-', '_', $lang);
        include_once($this->loadLanguage($lang));
        if (!isset($_SESSION['nm_session']['prod_v8']['login']['captcha_text']) ||
            $_SESSION['nm_session']['prod_v8']['login']['captcha_text'] !== $captcha
        ) {
            $str_error = $nm_lang['pass_captcha_error'];
        }
        if (!$str_error) {
            if (empty($pass_new)) $str_error = $nm_lang['pass_empty'];
            elseif (empty($pass_conf)) $str_error = $nm_lang['pass_conf_empty'];
            elseif ($pass_new !== $pass_conf) $str_error = $nm_lang['error_profile_password_conf'];
        }
        if (!$str_error) {
            $temMaiuscula = preg_match('/[A-Z]/', $pass_new);
            $temMinuscula = preg_match('/[a-z]/', $pass_new);
            $temNumeros = preg_match('/[0-9]/', $pass_new);
            $temTamanho = strlen($pass_new) >= 8;

            if (!$temMaiuscula || !$temMinuscula || !$temNumeros || !$temTamanho) {
                $str_error = $nm_lang['error_password_invalid'];
            }
        }
        if (!$str_error && !empty($email)) {
            if (filter_var($email, FILTER_VALIDATE_EMAIL) === false) {
                $str_error = $nm_lang['error_password_email'];
            } else {
                $v_file = $this->getDirConf()."prod.rec.conf.php";
                if (is_file($v_file)) @unlink($v_file);
                $v_email = [encode_string_utf8(trim($email))];
                file_put_contents($v_file, '<?php /*'.serialize($v_email).'*/?>');
            }
        }
        if ($str_error) {
            return json_encode(['result' => 'error', 'message' => $str_error]);
        }
        $ini_file = $this->getDirConf() . 'prod.config.php';
        $arr_ini = $this->nm_unserialize($ini_file);
        $arr_ini['GLOBAL']['LANGUAGE'] = $_SESSION['nm_session']['prod_v8']['lang'] = str_replace('_','-',$lang);
        $arr_ini['GLOBAL']['PASSWORD'] = encode_string_utf8(trim($pass_new));
        $str_xml = nm_serialize_ini($arr_ini);
        salva_xml($ini_file, $str_xml, $arr_ini);
        $_SESSION['nm_session']['prod_v8']['logged'] = true;
        unset($_SESSION['nm_session']['prod_v8']['url_rand'][$nm_url_rand]);
        return json_encode(['result' => 'success']);
    }
    function getDirProd() {
        return dirname(dirname(dirname(dirname(dirname(__DIR__)))));
    }

    function getDirConf() {
        return dirname(dirname(dirname(dirname(dirname(dirname(__DIR__)))))) . DIRECTORY_SEPARATOR . 'conf' . DIRECTORY_SEPARATOR;
    }

    function getDefaultLang() {
        $file = $this->getDirConf().'languague';
        if (is_file($file)) return trim(file_get_contents($file));

        $lang = strtolower(substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2));
        switch ($lang) {
            case 'pt': return 'pt-br';
            case 'es': return 'es-es';
            default: return 'en-us';
        }
    }

    function nm_prod_list_lang() {
        $path_lib = $this->getDirProd().'/lib/php/';
        $arr_lang = [];
        if ($res_dir = @opendir($path_lib)) {
            while (($file = @readdir($res_dir)) !== false) {
                if ($file !== '.' && $file !== '..' &&
                    substr($file, 0, 5) === 'lang.' &&
                    substr($file, -4) === '.php'
                ) {
                    $arr_data = @file($path_lib . $file);
                    $lang_key = substr($file, 5, -4);
                    $arr_lang[$lang_key] = isset($arr_data[1]) ? trim($arr_data[1]) : '';
                }
            }
            @closedir($res_dir);
        }
        return $arr_lang;
    }

    function changeLanguage($lang) {
        include_once($this->loadLanguage($lang));
        $result = [
            'result' => 'success',
            'lang_login_header' => $nm_lang['sc_prod'],
            'lang_login_pass_email' => $nm_lang['form_pass_email'],
            'lang_login_pass_new' => $nm_lang['form_pass_new'],
            'lang_login_pass_conf' => $nm_lang['form_pass_conf'],
            'lang_login_pass_language' => $nm_lang['form_language'],
            'lang_login_help' => $nm_lang['form_pass_help_title'],
            'nm_help_pass_first' => $nm_lang['form_pass_help_desc_1'],
            'nm_help_pass_second' => $nm_lang['form_pass_help_desc_2'],
            'nm_help_pass_third' => $nm_lang['form_pass_help_desc_3'],
            'nm_help_pass_four' => $nm_lang['form_pass_help_desc_4'],
            'nm_help_pass_five' => $nm_lang['error_password_email'],
            'nm_help_pass_six' => $nm_lang['form_pass_help_desc_6'],
            'loginbutton' => $nm_lang['button_save'],
            'copyright' => $nm_lang['copyright_label'],
            'version' => $nm_lang['version'],
            'captcha_placeholder' => $nm_lang['form_pass_captcha_placeholder'],
            'title' => "ScriptCase :: " . $nm_lang['sc_prod'],
        ];

        if (extension_loaded('gd') && function_exists('gd_info')) {
            $result['md_info_header'] = $nm_lang['info_page_pass_welcome'];
            $result['md_info_cnt_first'] = $nm_lang['info_page_pass_first'];
            $result['md_info_cnt_sec'] = $nm_lang['info_page_pass_second'];
            $result['md_info_btn'] = $nm_lang['info_page_pass_btn'];
        } else {
            $result['md_info_header'] = $nm_lang['info_page_pass_welcome'];
            $result['md_info_cnt_first'] = $nm_lang['info_page_gd'];
            $result['md_info_cnt_sec'] = "";
            $result['md_info_btn'] = $nm_lang['button_close'];
        }

        return json_encode($result);
    }

    function loadLanguage($lang) {
        $lang = str_replace('-', '_', $lang);
        $path = $this->getDirProd().'/lib/php/devel/lang/';
        if ($lang !== 'es_es' && $lang !== 'en_us' && $lang !== 'pt_br') $lang = 'en_us';
        return $path.$lang.'/ProdLogin.lang.php';
    }

    function nm_prod_get_version() {
        $dir = dirname(dirname(dirname(__DIR__)));
        $ver = is_file("$dir/prod.dat") ? file_get_contents("$dir/prod.dat") : "UNKNOWN";
        if (is_file("$dir/build.dat")) $ver .= ' Build: '.file_get_contents("$dir/build.dat");
        return $ver;
    }

    function nm_exclude_browser() {
        return strpos($_SERVER['HTTP_USER_AGENT'], 'Edg') !== false ? "display:none;" : "";
    }

    function nm_sc_dev() {
        if (!is_file($this->getDirProd().'/is_dev') && is_file(dirname(__DIR__,6).'/devel/conf/scriptcase/version.sc')) exit;
    }

    function generate_nm_url_rand($length = 32) {
        if (!isset($_SESSION['nm_session']['prod_v8']['url_rand'])) $_SESSION['nm_session']['prod_v8']['url_rand'] = [];
        $token = bin2hex(random_bytes($length));
        $_SESSION['nm_session']['prod_v8']['url_rand'][$token] = time();
        foreach ($_SESSION['nm_session']['prod_v8']['url_rand'] as $t => $ts) {
            if (time() - $ts > 600) unset($_SESSION['nm_session']['prod_v8']['url_rand'][$t]);
        }
        return $token;
    }

    function validate_nm_url_rand($token) {
        if (empty($token) || !isset($_SESSION['nm_session']['prod_v8']['url_rand'][$token])) return false;
        return true;
    }

    function DisplayContent() {
        global $nm_template;
        $nm_template->SetVar('nm_url_rand', $this->generate_nm_url_rand());
        $nm_template->Display('body_prod_login');
    }

    function PageJavascript() {
        global $nm_lang;
        $this->AddJavascript("document.title = ' ScriptCase :: ".$nm_lang['sc_prod']."';");
    }

    function PageJs() {
        $this->AddJs('third', 'jquery/js/jquery.js');
        $this->AddJs('third', 'semantic-ui/semantic.min.js');
    }

    function PageStyle() {
        $this->AddStyleCss('third', 'font-awesome/6/css/all.min.css');
        $this->AddStyleCss('third', 'semantic-ui/semantic.min.css');
        $this->AddStyle(
            "body,html{margin:0;padding:0;height:100%;width:100%;background:url(../../../../img/bgLogin.jpg) 0 0/cover #bfd1e3}
            .nmFormField{display:flex;justify-content:center;align-items:flex-start;flex-flow:column nowrap}
            #footer_info{display:flex;flex-direction:row;align-items:center;justify-content:center;position:fixed;bottom:0;left:0;width:100vw;color:#efefef9c;font-size:12px;background:rgba(29,46,61,.67);height:40px;padding:0 20px}
            #footer_info .spacer{flex-grow:1}"
        );
        $this->AddStyle(
            ".nm_help_red{color:red!important}.nm_help_green{color:green!important}
            .login-container{min-width:560px;max-width:560px;position:relative;margin:0 auto;background-color:#fff;border-radius:4px;padding:1.5rem 0 0;box-sizing:border-box;}
            .group{padding:0 1.5rem}
            .bullet.item::before {content: '\\2022'; margin-right: 0.1rem;}"
        );
    }
}
